/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import com.google.common.annotations.GwtCompatible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.python.google.common.base.Joiner;
import org.python.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public final class Objects {
    private Objects() {
    }

    public static boolean equal(@Nullable Object object, @Nullable Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static int hashCode(Object ... objectArray) {
        return Arrays.hashCode(objectArray);
    }

    public static ToStringHelper toStringHelper(Object object) {
        return new ToStringHelper(Objects.simpleName(object.getClass()));
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(Objects.simpleName(clazz));
    }

    public static ToStringHelper toStringHelper(String string) {
        return new ToStringHelper(string);
    }

    private static String simpleName(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(36);
        if (n == -1) {
            n = string.lastIndexOf(46);
        }
        return string.substring(n + 1);
    }

    public static <T> T firstNonNull(@Nullable T t, @Nullable T t2) {
        return t != null ? t : Preconditions.checkNotNull(t2);
    }

    public static class ToStringHelper {
        private final List<String> fieldString = new ArrayList<String>();
        private final String className;
        private static final Joiner JOINER = Joiner.on(", ");

        private ToStringHelper(String string) {
            this.className = Preconditions.checkNotNull(string);
        }

        public ToStringHelper add(String string, @Nullable Object object) {
            return this.addValue(Preconditions.checkNotNull(string) + "=" + object);
        }

        public ToStringHelper addValue(@Nullable Object object) {
            this.fieldString.add(String.valueOf(object));
            return this;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(100).append(this.className).append('{');
            return JOINER.appendTo(stringBuilder, (Iterable<?>)this.fieldString).append('}').toString();
        }
    }
}

